	% Example 15.5  
	clear all, close all, clc
	wcT = 0.05*pi;		wsT = 0.1*pi;	dc = 0.01;	ds = 0.001;
	wT = linspace(0,pi,1000);
	M1 = 3; M2 = 2;				% M1*M2 < 2*pi/wsT	
	Be = M1*[wcT wsT]; d = [dc/6 sqrt(ds)/4];
	[N1, Be, D, W] = HERRMANN_LP_FIR_ORDER(Be, d); N1
	[h1, Err] = REMEZ_FIR(N1, Be, D, W, 'm');
	H1 = freqz(h1,1,M1*wT); 					% Filter H1
	subplot(3,1,1),  PLOT_MAG_Z_dB(wT, H1, pi, 90, 'H_1')
	Be = M1*M2*[wcT wsT]; 
	d = [dc sqrt(ds)]/2;
	[N2, Be, D, W] = HERRMANN_LP_FIR_ORDER(Be, d); N2
	W = [1 0.3]
	[h2, Err] = REMEZ_FIR(N2, Be, D, W, 'm');   %  Filter H2
	H2 = freqz(h2,1,  wT); 
	subplot(3,1,2), PLOT_MAG_Z_dB(wT, H2, pi, 90, 'H_2') 
	Be = M1*M2*[wcT wsT];  d = [dc sqrt(ds)]/2;
	[NK, Be, D, W] = HERRMANN_LP_FIR_ORDER(Be, d); NK
	W = [1 0.3]
	[hK, Err] = REMEZ_FIR(NK, Be, D, W, 'm'); 
	HK = freqz(hK,1,M1*M2* wT);					% Kernel filter
	subplot(3,1,3), PLOT_MAG_Z_dB(wT, HK, pi, 90, 'H_K')
	HI1 = H1;	HI2 = H2; 			 
	H = HI1.*HI2.*HK.*H2.*H1;		% Overall filter
	
	figure(2),	subplot(3,1,1), 	
	PLOT_MAG_Z_dB(wT, H, pi, 100, 'H')
	Amax= max(H_2_MAG(H(1:50)))-min(H_2_MAG(H(1:50)))
	Amin = -max(H_2_MAG(H(101:end)))
	A = 20*log10((1+dc)/(1-dc))
	
	h1=[h1 0 0];
	P1 = reshape(h1, M1, length(h1)/M1)
	h2=[h2 0 ];
	P2 = reshape(h2, M2, length(h2)/M2)
    hK=[hK  0 ];
	PK = reshape(hK, M2, length(hK)/M2)
	
	
